$(document).ready(function()
{
	common.show_main_view_intreface()
	common.show_errors_info()

	const mcu_common_script = common.load_script('mcu_common.js')
	const network_settings_script = common.load_script('network_settings.js')
	const one_wire_script = common.load_script('one_wire.js')
	const app_sw_control_script = common.load_script('app_sw_control.js')
    const app_sw_script = common.load_script('app_sw.js')
    Promise.all([mcu_common_script,
				network_settings_script,
		 		one_wire_script,
		 		app_sw_control_script,
				app_sw_script])
	.then(() => app_sw_control.main())
	.then(() => app_sw.main())
	.then(() => mcu_common.request_board_types())
	.then(text => common.response_ready(text))
	.then(values => {//new Promise(function(resolve, reject) {
		let product_code = values[0]
		let types = values.slice(1)
		let product_code_arr = get_set_value.ip2array(product_code)
		mcu_common.show_boards_types_setting()
		mcu_common.show_boards_by_type(types, product_code_arr)
		network_settings.show("old")
	})
	.then(() => one_wire.request_sensors_count())
	.then(text => common.response_ready(text))
	.then(count => one_wire.request_sensors_all(count, configuration.response_lenght()))
	.then(values => {
		let sensors_ID = values.filter(element => element !== "0x0")
		//console.log(sensors_ID)
		one_wire.show(sensors_ID, values.length)

		common.on_page_loading_finished()
		user.parse_page()
	})
})

